#define WIN32_LEAN_AND_MEAN
#define UNICODE
#define _UNICODE
#include <windows.h>
#include <winioctl.h>
#include <stdio.h>
#include "ioctlcmd.h"

int __cdecl wmain(int argc, wchar_t** argv)
{
	PCWSTR pDevName = L"\\\\.\\Headless";
	HANDLE hFile = CreateFile(pDevName, GENERIC_READ, 0, NULL, OPEN_EXISTING, 0X80, NULL);
	if(hFile == INVALID_HANDLE_VALUE)
	{
		wprintf(L"Couldn't open %s - err = %lu\n", pDevName, GetLastError());
		return 1;
	}
	bool quit = false;
	static const PCWSTR pOptions[] = {L"Init Headless", L"Put String", L"Query Info", L"Dump Command"};
	static const ULONG ioctls[] = {IOCTL_INIT_HEADLESS, IOCTL_HEADLESS_STRING, IOCTL_HEADLESS_QUERY_INFO, IOCTL_HEADLESS_DUMP_COMMAND};
	for(;;)
	{
		puts("Headless IOCTL's. Enter option to execute, 0 to exit:");
		for(int i = 0; i < ARRAYSIZE(pOptions); ++i)
		{
			wprintf(L"%d: %s\n", i + 1, pOptions[i]);
		}
		int option = 0;
		if((scanf("%d", &option) == 1) && (option <= ARRAYSIZE(pOptions)))
		{
			if(option == 0)
			{
				break;
			}
			char buffer[500] = {0};
			DWORD bytes = 0;
			if(!DeviceIoControl(hFile, ioctls[option - 1], NULL, 0, buffer, ARRAYSIZE(buffer), &bytes, NULL))
			{
				printf("DeviceIoControl failed with error %lu\n", GetLastError());
			}
			else
			{
				printf("DeviceIoControl succeeded and returned %.*s\n", bytes, buffer);
			}
		}
		else
		{
			printf("Invalid choice: %d\n", option);
		}
	}
	CloseHandle(hFile);
}