// cl /Ox /GL /MT suspendresume.cpp /link /opt:icf /opt:ref /out:\\2257virt\bits\suspendresume.exe user32.lib
#define WIN32_LEAN_AND_MEAN
#define UNICODE
#define _UNICODE
#include <windows.h>
#include <stdio.h>
#include <stdlib.h>

typedef long (WINAPI*NtProcFn)(HANDLE);
NtProcFn ntSusProc = NULL;
NtProcFn ntResProc = NULL;

void FindNtFuncs()
{
   HMODULE hNt = GetModuleHandle(L"ntdll.dll");
   ntSusProc = (NtProcFn)GetProcAddress(hNt, "NtSuspendProcess");
   ntResProc = (NtProcFn)GetProcAddress(hNt, "NtResumeProcess");
}

int __cdecl wmain(int argc, wchar_t** argv)
{
   if(argc < 2)
   {
      return puts("Usage: SuspendResume pid");
   }
   FindNtFuncs();
   int pid = _wtoi(argv[1]);
   HANDLE hProc = OpenProcess(GENERIC_ALL, FALSE, pid);
   if(hProc)
   {
       long stat = ntSusProc(hProc);
       if(stat < 0)
       {
           printf("Failed to suspend process err=%#08x\n", stat);
       }
       else
       {
           puts("Press enter to resume process");
           getchar();
           ntResProc(hProc);
       }
       CloseHandle(hProc);
   }
   else
   {
       printf("OpenProcess failed returned err=%lu\n", GetLastError());
   }
   return 0;
}