// cl /Ox /MT /GL imapi.cpp /link uuid.lib ole32.lib oleaut32.lib
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <imapi.h>
#include <stdio.h>
#include <propidl.h>

#define CHECK_FAIL(exp) \
	{ \
		hr = (exp); \
		if(hr != S_OK) \
		{ \
			printf(#exp " not S_OK! err = %#x\n", hr); \
			return 1; \
		} \
	}

#define REPORT_FAIL(exp) \
	{ \
		hr = (exp); \
		if(hr != S_OK) \
		{ \
			printf(#exp " not S_OK! err = %#x\n", hr); \
		} \
	}

/* {E3BC42CE-4E5C-11D3-9144-00104BA11C5E} IJolietDiscMaster
   {E3BC42CD-4E5C-11D3-9144-00104BA11C5E) IRedbookDiscMaster
*/
int __cdecl main()
{
	HRESULT hr = S_OK;
	CoInitializeEx(NULL, COINIT_APARTMENTTHREADED | COINIT_DISABLE_OLE1DDE);
	IDiscMaster* pDiscMaster = NULL;
	CHECK_FAIL(CoCreateInstance(
		CLSID_MSDiscMasterObj,
		NULL,
		CLSCTX_ALL,
		IID_PPV_ARGS(&pDiscMaster)
	));
	CHECK_FAIL(pDiscMaster->Open());
	puts("Opened DiscMaster");
	IEnumDiscMasterFormats* pFormats = NULL;
	CHECK_FAIL(pDiscMaster->EnumDiscMasterFormats(&pFormats));
	IID fmtIid = IID_NULL;
	ULONG got = 0;
	puts("Enumming formats");
	while((hr = pFormats->Next(1, &fmtIid, &got)) == S_OK)
	{
		WCHAR fmtStr[50] = {0};
		StringFromGUID2(fmtIid, fmtStr, 50);
		printf("Found format '%S'\n", fmtStr);
	}
	IJolietDiscMaster* pJoliet = NULL;
	CHECK_FAIL(pDiscMaster->SetActiveDiscMasterFormat(IID_PPV_ARGS(&pJoliet)));
	IPropertyStorage* pProps = NULL;
	puts("Getting Joliet properties");
	CHECK_FAIL(pJoliet->GetJolietProperties(&pProps));
	IEnumSTATPROPSTG* pEnumProps = NULL;
	if(SUCCEEDED(pProps->Enum(&pEnumProps)))
	{
		STATPROPSTG propstat = {0};
		PROPSPEC propToRead = {0};
		propToRead.ulKind = PRSPEC_PROPID;
		while((hr = pEnumProps->Next(1, &propstat, &got)) == S_OK)
		{
			propToRead.propid = propstat.propid;
			PROPVARIANT propVar = {0};
			pProps->ReadMultiple(1, &propToRead, &propVar);
			VARIANT strVar = {0};
			VariantChangeType(&strVar, (VARIANTARG*)&propVar, 0, VT_BSTR);
			printf(
				"Name: '%S'\nValue: '%S'\n\n",
				propstat.lpwstrName,
				strVar.bstrVal
			);
			VariantClear(&strVar);
			PropVariantClear(&propVar);
			if(propstat.lpwstrName)
			{
				CoTaskMemFree(propstat.lpwstrName);
			}
		}
		pEnumProps->Release();
	}
	pProps->Release();
	IEnumDiscRecorders* pEnumRec = NULL;
	CHECK_FAIL(pDiscMaster->EnumDiscRecorders(&pEnumRec));
	puts("Enumming recorders:");
	IDiscRecorder* pRecorder = NULL;
	while((hr = pEnumRec->Next(1, &pRecorder, &got)) == S_OK)
	{
		BSTR vendorId = NULL, prodId = NULL, rev = NULL;
		REPORT_FAIL(pRecorder->GetDisplayNames(&vendorId, &prodId, &rev));
		BSTR path = NULL;
		REPORT_FAIL(pRecorder->GetPath(&path));
		long type = 0, flags = 0, recType = 0;
		REPORT_FAIL(pRecorder->QueryMediaType(&type, &flags));
		REPORT_FAIL(pRecorder->GetRecorderType(&recType));
		printf(
			"Vendor Id: %S\nProduct Id: %S\nRevision: %S\nPath: %S\nMedia Type: %li\nMedia Flags: %#x\nRec Type: %li\n\n",
			vendorId, prodId, rev, path, type, flags, recType
		);
		SysFreeString(vendorId);
		SysFreeString(prodId);
		SysFreeString(rev);
		SysFreeString(path);
		REPORT_FAIL(pDiscMaster->SetActiveDiscRecorder(pRecorder));
		pRecorder->Release();
	}
	pEnumRec->Release();
	pJoliet->Release();
	pDiscMaster->Close();
	CoUninitialize();
}
