// cl /Od /MT themeprev.cpp /link /out:\\2257virt\bits\themeprev.exe ole32.lib oleaut32.lib user32.lib
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <objbase.h>
#include <stdio.h>
#include <conio.h>
#include <string.h>

MIDL_INTERFACE("B63705F2-B2A2-401E-A20D-643E6B554A1D")
IThemePreview : public IUnknown
{
	virtual HRESULT __stdcall UpdatePreview(IPropertyBag* pPropertyBag) = 0;
	virtual HRESULT __stdcall CreatePreview(
		HWND hwndParent, 
		UINT dwFlags, 
		UINT dwStyle, 
		UINT dwExStyle,
		int x, int y,
		int nWidth, int nHeight,
		IPropertyBag* pPropertyBag
	) = 0;
};

MIDL_INTERFACE("55272A00-42CB-11CE-8135-00AA004BB851")
INullPropBag : IUnknown
{
	STDMETHOD(Read)(LPWSTR pszPropName, VARIANT* pVar, IErrorLog* pErrorLog) = 0;
	STDMETHOD(Write)(LPWSTR pszPropName, VARIANT* pVar) = 0;
};

struct NullPropBag : public INullPropBag
{
	STDMETHODIMP QueryInterface(REFIID iid, PVOID* ppv)
	{
		if(iid == __uuidof(INullPropBag) || iid == IID_IUnknown)
		{
			*ppv = this;
			return S_OK;
		}
		return E_NOINTERFACE;
	}

	STDMETHODIMP_(ULONG) AddRef() {return 1;}
	STDMETHODIMP_(ULONG) Release() {return 1;}

	STDMETHODIMP Read(LPWSTR pszPropName, VARIANT* pVar, IErrorLog* pErrorLog)
	{
		HRESULT hr = E_INVALIDARG;
		if(_wcsicmp(pszPropName, L"Background_Path") == 0)
		{
			V_VT(pVar) = VT_BSTR;
			V_BSTR(pVar) = SysAllocString(L"C:\\windows\\web\\wallpaper\\Windows 2000.jpg");
			hr = S_OK;
		}
		else if(_wcsicmp(pszPropName, L"Background_Path") == 0)
		{
			V_VT(pVar) = VT_BOOL;
			V_BOOL(pVar) = VARIANT_TRUE;
			hr = S_OK;
		}
		printf("NullPropBag asked to Read prop %S\n", pszPropName);
		return hr;
	}

	STDMETHODIMP Write(LPWSTR pszPropName, VARIANT* pVar)
	{
		VARIANTARG var;
		VariantInit(&var);
		VariantChangeType(&var, pVar, 0, VT_BSTR);
		printf("NullPropBag asked to Write prop %S (%S)\n", pszPropName, V_VT(&var));
		VariantClear(&var);
		return S_OK;
	}
};

int __cdecl main()
{HKEY_LOCAL_MACHINE;SM_ARRANGE
    CoInitialize(NULL);
	IThemePreview* pTest = NULL;
	CLSID clsidThemePrev = GUID_NULL;
	CLSIDFromString(L"{B7BBD408-F09C-4AA8-B65E-A00B8FE0F0B9}", &clsidThemePrev);
	HRESULT hRes = CoCreateInstance(clsidThemePrev, NULL, CLSCTX_INPROC, __uuidof(*pTest), (void**)&pTest);
	if(FAILED(hRes))
	{
		CoUninitialize();
		return wprintf(L"Failed to create IThemePreview with err = %#x\n", hRes);
	}
	PVOID* ppTest = *((PVOID**)pTest);
	printf("IThemePreview VTbl:\n");
	for(int i = 0; i <= 4; ++i)
	{
		printf("ppTest[%d] = %p\n", i, ppTest[i]);
	}
	printf("CreatePreview at %p\n", ppTest[4]);
	NullPropBag bag;
	hRes = pTest->CreatePreview(
		GetConsoleWindow(),
		3, // 1 = show monitor, 2 = QueryPropBag
		WS_POPUP | WS_VISIBLE,
		0,
		CW_USEDEFAULT,
		CW_USEDEFAULT,
		400,
		300,
		(IPropertyBag*)&bag
	);
	printf("CreatePreview returned %#x\nPress Enter to exit", hRes);
	while(!_kbhit())
	{
		MSG msg = {0};
		while(PeekMessage(&msg, NULL, 0, 0, PM_REMOVE))
		{
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
		Sleep(100);
	}
	pTest->Release();
	CoUninitialize();
}
